/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	OffsetPlane.cpp

#include <stdafx.h>

#include "cUtility.h"
#include "CWorkplane.h"
#include "cApplication.h"


HRESULT Offsetplane(ITopology *pGeometry, double offsetDistance, CString workplaneName, CString sketchName, VARIANT_BOOL bNoSketch, long color, IWorkplane **retDispatch)
{
	// Creates a offseted Plane with the specified distance and return the 
	// Offseted workplane

	START_METHOD("Offsetplane")

	HRESULT status=CONV_SUCCESS;

	VARIANT_BOOL blnGeometry;

	CHECK_VAR_STATUS(pGeometry)
	
	IObject *object = CAST(IObject, pGeometry);
	CHECK_VAR_STATUS(object)

	status = object->IsA(GetBSTR("Geometric"),&blnGeometry);
	CHECK_RETURN_STATUS(status)

	IWorkplane *pOffsetPlane = NULL;

	if (blnGeometry) {
		IGraphicDocument *activeGraphicDoc = NULL;
		IPartDocument *activePart = NULL;
		IWorkplane *activeWorkplane = NULL;
		ISketch *activeSketch = NULL;

		status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
		CHECK_RETURN_STATUS(status)

		IDesign *design= NULL;
		status = activePart->GetDesign(&design);
		CHECK_RETURN_STATUS(status)

		IGeometric *geometry= CAST(IGeometric, pGeometry);

		IGeometry *pGeom1 = NULL;
		status = geometry->GetGeometricForm(&pGeom1);
		CHECK_RETURN_STATUS(status)

		// Create a Offset Plane
		IOffsetPlane *pOffPlane= NULL;
		status = (GetCLASS(OffsetPlane))->CreateOffsetPlane(CAST(IPlane,pGeom1), offsetDistance, &pOffPlane);
		CHECK_RETURN_STATUS(status)

		// Create the PlaneThroughObjects Workplane
		status = design->CreateWorkplane(CAST(IPlane,pOffPlane), workplaneName.AllocSysString(),&pOffsetPlane);
		CHECK_RETURN_STATUS(status)

		// Create a sketch with the given sketch name
		if(!bNoSketch)
		{
			ISketch *pOffsetPlanesSketch = NULL;
			status = pOffsetPlane->CreateSketch(sketchName.AllocSysString(), &pOffsetPlanesSketch);
			CHECK_RETURN_STATUS(status)
			status = activeGraphicDoc->SetActiveSketch(pOffsetPlanesSketch) ;
			CHECK_RETURN_STATUS(status)

			// Set the color for the sketch
			if(color<0 || color > 11)
				color = 4 ;

			IColor *pNewColor= NULL;
			status = (GetCLASS(Color))->CreateColor(1, color * 30, 0.35, 1,&pNewColor);
			CHECK_RETURN_STATUS(status)

			ISketch *sketch = CAST(ISketch, pOffsetPlanesSketch);

			status = sketch->SetColor(pNewColor);
			CHECK_RETURN_STATUS(status)
		}
	}
	else
	{
		AfxMessageBox ("Improper Selection of Entities");
		pOffsetPlane = NULL;
	}
	*retDispatch=pOffsetPlane;

    END_METHOD("Offsetplane")
}
